#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>

char player;
int dupout;

void nextmove ( int sig )
{
   int row, col;

   scanf("%d%d", &row, &col);
   printf("%d %d\n", row, col);
   fflush(stdout);
}

void leave ( int sig )
{
   close(1);
   dup(dupout);
   printf("\t\tPlayer %c leaving\n", player);
   exit(0);
}

int main ( int argc, char *argv[] )
{
   int pfd;

   if (argc != 3) {
      fprintf(stderr, "*** Run as player which pipefd\n");
      exit(1);
   }

   player = argv[1][0];
   pfd = atoi(argv[2]);

   signal(SIGUSR1, nextmove);
   signal(SIGINT, leave);

   printf("\t\tPlayer %c starts\n", player);

   dupout = dup(1);
   close(1); dup(pfd);

   while (1) pause();

   exit(0);
}
