#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#define INTERACTIVE 1
#define AUTOPLAY 2

void readboard ( int brdshm )
{
   int *B, i;
   FILE *fp;
   char type[16];
   int start, end;

   B = shmat(brdshm, NULL, 0);
   for (i=1; i<=100; ++i) B[i] = 0;
   fp = (FILE *)fopen("ludo.txt", "r");
   while (1) {
      fscanf(fp, "%s", type);
      if (type[0] == 'E') break;
      if (type[0] == 'L') {
         fscanf(fp, "%d%d", &start, &end);
         B[start] = end - start;
      } else if (type[0] == 'S') {
         fscanf(fp, "%d%d", &start, &end);
         B[start] = end - start;
      } else {
         fprintf(stderr, "*** Bad line in inout file\n");
         shmdt(B);
         shmctl(brdshm, IPC_RMID, NULL);
         exit(1);
      }
   }
   shmdt(B); 
}

void initplrs ( int n, int plrshm )
{
   int *P, i;

   P = shmat(plrshm, NULL, 0);
   for (i=0; i<n; ++i) P[i] = 0;
   P[n] = n;
   shmdt(P);
}

void endgame ( int plrpid, int brdpid, int xplrpid, int xbrdpid )
{
   while (getchar() != '\n');
   printf("Hit return to end the game..."); fflush(stdout);
   while (getchar() != '\n');
   kill(plrpid, SIGUSR2);
   waitpid(xplrpid, NULL, 0);
   kill(brdpid, SIGUSR2);
   waitpid(xbrdpid, NULL, 0);
}

void gameloop ( int n , int plrshm, int plrpid , int brdpid, int xplrpid, int xbrdpid, int pfdin, int dupin )
{
   int mode = INTERACTIVE;
   int *P;
   int delay = 1000000;
   char cmd[32], ack[32];

   close(0); dup(pfdin); scanf("%s", ack); close(0); dup(dupin);

   P = (int *)shmat(plrshm, NULL, 0);
   while (P[n] > 0) {
      if (mode == INTERACTIVE) {
         printf("$ "); fflush(stdout);
         scanf("%s", cmd);
         if ((cmd[0] == 'a') || (cmd[0] == 'A')) {
            mode = AUTOPLAY; printf("Starting autoplay...\n"); continue;
         } else if ((cmd[0] == 'q') || (cmd[0] == 'Q')) {
            break;
         } else if ((cmd[0] == 'd') || (cmd[0] == 'D')) {
            scanf("%d", &delay); delay *= 1000; continue;
         } else if ((cmd[0] != 'n') && (cmd[0] != 'N')) {
            continue;
         }
      } else if (mode == AUTOPLAY) {
         cmd[0] = 'n';
      }
      kill(plrpid, SIGUSR1);
      close(0); dup(pfdin); scanf("%s", ack); close(0); dup(dupin);
      if (mode == AUTOPLAY) usleep(delay);
   }
   endgame(plrpid, brdpid, xplrpid, xbrdpid);
   shmdt(P);
}

int main ( int argc, char *argv[] )
{
   int n;
   char narg[16];
   pid_t plrpid, brdpid, xplrpid, xbrdpid;
   int brdshm, plrshm;
   int pfd[2], dupin;
   char pfdarg[16], brdarg[16];

   n = (argc > 1) ? atoi(argv[1]) : 2; 

   brdshm = shmget(ftok("/home", 'b'), 101 * sizeof(int), 0777 | IPC_CREAT | IPC_EXCL);
   readboard(brdshm);

   plrshm = shmget(ftok("/home", 'p'), (n + 1) * sizeof(int), 0777 | IPC_CREAT | IPC_EXCL);
   initplrs(n,plrshm);

   sprintf(narg, "%d", n);
   pipe(pfd);
   sprintf(pfdarg, "%d", pfd[1]);

   dupin = dup(0);

   if (!(xbrdpid = fork())) {
      execlp("xterm",
         "xterm", "-T", "Board", "-fs", "15", "-geometry", "150x24+50+100", "-bg", "#003300",
         "-e", "./board", narg, pfdarg, NULL);
   } else {
      close(0);
      dup(pfd[0]);
      scanf("%d", &brdpid);
      close(0);
      dup(dupin);
   }

   sprintf(brdarg, "%d", brdpid);

   if (!(xplrpid = fork())) {
      execlp("xterm",
         "xterm", "-T", "Players", "-fs", "15", "-geometry", "100x24+1000+100", "-bg", "#000033",
         "-e", "./players", narg, pfdarg, brdarg, NULL);
   } else {
      close(0);
      dup(pfd[0]);
      scanf("%d", &plrpid);
      close(0);
      dup(dupin);
   }

   gameloop(n,plrshm,plrpid,brdpid,xplrpid,xbrdpid,pfd[0],dupin);

   shmctl(brdshm, IPC_RMID, NULL);
   shmctl(plrshm, IPC_RMID, NULL);

   exit(0);
}
