#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ipc.h>
#include <sys/shm.h>

int n;
int plrshm, brdshm;
int pfd, dupout;

void printboard ( int sig )
{
   int *P, *B;
   int i, j, r, c;
   char brd[12][50] = {
      "",
      "|100| 99| 98| 97| 96| 95| 94| 93| 92| 91|",
      "| 81| 82| 83| 84| 85| 86| 87| 88| 89| 90|",
      "| 80| 79| 78| 77| 76| 75| 74| 73| 72| 71|",
      "| 61| 62| 63| 64| 65| 66| 67| 68| 69| 70|",
      "| 60| 59| 58| 57| 56| 55| 54| 53| 52| 51|",
      "| 41| 42| 43| 44| 45| 46| 47| 48| 49| 50|",
      "| 40| 39| 38| 37| 36| 35| 34| 33| 32| 31|",
      "| 21| 22| 23| 24| 25| 26| 27| 28| 29| 30|",
      "| 20| 19| 18| 17| 16| 15| 14| 13| 12| 11|",
      "|  1|  2|  3|  4|  5|  6|  7|  8|  9| 10|",
      ""
   };
   char *cp;
   char ack[32] = "Done\n";

   P = (int *)shmat(plrshm, NULL, 0);
   cp = brd[0];
   for (i=0; i<n; ++i) {
      if (P[i] == 100) { sprintf(cp, "%c ", 'A' + i); cp += 2; }
   }
   cp = brd[11];
   for (i=0; i<n; ++i) {
      if (P[i] == 0) { sprintf(cp, "%c ", 'A' + i); cp += 2; }
   }
   for (i=1; i<=99; ++i) {
      for (j=0; j<n; ++j) {
         if (P[j] == i) {
            r = 10 - (i - 1) / 10;
            if (r % 2 == 0) c = 1 + 4 * ((i - 1) % 10); else c = 1 + 4 * (9 - (i - 1) % 10);
            brd[r][c] = brd[r][c+2] = ' '; brd[r][c+1] = 'A' + j;
            break;
         }
      }
   }
   printf("%s\n", brd[0]);
   B = (int *)shmat(brdshm, NULL, 0);
   printf("+---+---+---+---+---+---+---+---+---+---+\n");
   for (i=1; i<=10; ++i) {
      printf("%s\t", brd[i]);
      for (j=(10-i)*10+1; j<=(11-i)*10; ++j) {
         if (B[j] > 0) printf("L(%2d -> %2d) ", j, j + B[j]);
         else if (B[j] < 0) printf("S(%2d -> %2d) ", j, j + B[j]);
      }
      printf("\n");
      printf("+---+---+---+---+---+---+---+---+---+---+\n");
   }
   printf("%s\n", brd[11]);
   shmdt(B);
   shmdt(P);
   fflush(stdout);
   close(1); dup(pfd); printf("%s", ack); fflush(stdout); close(1); dup(dupout);
}

int main ( int argc, char *argv[] )
{
   n = atoi(argv[1]);
   pfd = atoi(argv[2]);
   dupout = dup(1);
   close(1);
   dup(pfd);
   printf("%d\n",getpid());
   fflush(stdout);
   close(1);
   dup(dupout);

   plrshm = shmget(ftok("/home", 'p'), (n + 1) * sizeof(int), 0777);
   brdshm = shmget(ftok("/home", 'b'), 101 * sizeof(int), 0777);

   signal(SIGUSR1, printboard);

   sleep(1); /* Wait for coordinator to read the PIDs */
   printboard(SIGUSR1);
   
   while (1) pause();

   exit(0);
}
