%{
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "y.tab.h"
%}

ws      [ \t\n]+
id      [a-zA-Z_][a-zA-Z0-9_]*
num     [0-9]+
posnum	\+{num}
negnum	-{num}
iconst	({posnum}|{negnum})
flt	(([0-9]+\.[0-9]*)|([0-9]*\.[0-9]+))([eE][+-]?[0-9]+)?
posflt	\+{flt}
negflt	-{flt}
fconst	({posflt}|{negflt})

%%

{ws}                            { }
long{ws}int                     { return LNG; }
long                            { return LNG; }
int                             { return INT; }
float                           { return FLT; }
double                          { return DBL; }
struct                          { return STRUCT; }
if				{ return IF; }
else				{ return ELSE; }
while				{ return WHILE; }
{id}                            { yylval.lexstr = strdup(yytext); return ID; }
{num}                           { yylval.lexval = atoi(yytext); return NUM; }
{iconst}			{ yylval.iconst = atoi(yytext); return ICONST; }
{flt}				{ yylval.fconst = atof(yytext); return UFLT; }
{fconst}			{ yylval.fconst = atof(yytext); return FCONST; }
\[                              { return yytext[0]; }
\]                              { return yytext[0]; }
\{                              { return yytext[0]; }
\}                              { return yytext[0]; }
,                               { return yytext[0]; }
=				{ return yytext[0]; }
\+				{ return yytext[0]; }
-				{ return yytext[0]; }
\*				{ return yytext[0]; }
\/				{ return yytext[0]; }
%				{ return yytext[0]; }
\(				{ return yytext[0]; }
\)				{ return yytext[0]; }
\.				{ return yytext[0]; }
;                               { return yytext[0]; }
&&				{ return AND; }
\|\|				{ return OR; }
!				{ return NOT; }
==				{ yylval.opcode = EQ; return EQ; }
!=				{ yylval.opcode = NE; return NE; }
\<				{ yylval.opcode = LT; return LT; }
\<=				{ yylval.opcode = LE; return LE; }
>				{ yylval.opcode = GT; return GT; }
>=				{ yylval.opcode = GE; return GE; }
.                               { fprintf(stderr, "*** Lex error: Unrecognized char '%s'\n", yytext); }

%%

int yywrap ( ) { return 1; }
