extern FILE *yyin ;
extern int yylex() ;
void yyerror ( char * ) ;
int yyparse () ;

typedef struct typeentry {
   int cat;            /* Basic types like CHR, UINT, FLT, DBL or
                          Array type ARR or
                          structure type STRUCT */
   int dim;            /* Relevant only for ARR type */
   int ref;            /* ARR: Element type (index in type table)
                          STRUCT: Index of the symbol table for the structure */
   int width;          /* sizeof field */
   char *name;         /* Relevant only for STRUCT */
} ttentry;

typedef struct nameentry {
   char *name;         /* Name of the variable */
   int typeref;        /* Index in the type table */
   int offset;         /* Memory offset in the data segment or structure */
} stentry;

struct _attr {
   int typeref;
   int stno;
};

union _addrtype {
   int iconst;
   double fconst;
   int temp;
   int offset;
   int toffset;
};

struct _addr {
   int cat;
   int type;
   union _addrtype value;
};

extern void addbasictypes () ;
extern int searchbasictype ( int ) ;
extern int addarraytype ( int , int ) ;
extern int searchstructtype ( char * ) ;
extern int addstructtype ( char * ) ;
extern void setstructwidth ( int ) ;
extern int getstref ( int ) ;
extern int getstructref ( int ) ;
extern struct _attr *genattr ( int , int ) ;
extern void STadd ( char * , int , int ) ;
extern int STget ( char * , int ) ;
void printtype ( int ) ;
void printalltypes ( ) ;
void printbasicname ( int ) ;
void printsymbols ( int ) ;
void printallsymbols ( ) ;

extern struct _addr *iconst2addr ( int ) ;
extern struct _addr *fconst2addr ( double ) ;
extern struct _addr *id2addr ( char * , int ) ;
extern struct _addr *memload ( struct _addr * ) ;
extern void addr2idx ( struct _addr * , int ) ;
extern struct _addr *arrid2addr ( char * , struct _addr * , int ) ;
extern struct _addr *arr2addr ( struct _addr * , struct _addr * ) ;
extern struct _addr *struct2addr ( struct _addr * , struct _addr * ) ;
extern struct _addr *item2addr ( struct _addr * ) ;
extern void printarg ( struct _addr * ) ;
extern int LCA ( int , int ) ;
extern void printtypeshort ( int ) ;
extern void typeconv ( int , int ) ;
extern struct _addr *widen (struct _addr * , int ) ;
extern struct _addr *operation ( struct _addr * , char , struct _addr * ) ;
extern void memstore ( struct _addr * , struct _addr * ) ;
