%{
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defs.h"
%}

%union {
   int lexval;
   char *lexstr;
   struct _attr *attr;
   struct _addr *addr;
   int iconst;
   double fconst;
   int stno;
   int typeref;
}

%token LNG INT FLT DBL STRUCT ARR
%token <lexstr> ID
%token <lexval> NUM
%token <iconst> ICONST
%token <fconst> UFLT
%token <fconst> FCONST
%token <addr> MEMLOC TEMP MEMLOCTEMP

%type <stno> STN0 STN1 STN2 STN3 STN4
%type <typeref> BASIC
%type <attr> VT1 VT2 VT3 VT4 VT5 VT6 VT7 DIM
%type <addr> FACTOR TERM EXPR ITEM SMPLITEM AREF

%%

PROG	: STN0 DECLIST PRT STMTLIST
	;

PRT	: { printalltypes(); printallsymbols(); printf("\n\n"); } ;

DECLIST	: DECLIST STN1 DECL
	| STN2 DECL
	;

DECL	: BASIC VT1 LIST ';'
	| STRUCT ID '{' STN3 DECLIST WD '}' ';'
	| STRUCT ID '{' STN3 DECLIST WD '}' VT2 LIST ';'
	| STRUCT ID VT3 LIST ';'
	;

STN0	: { $$ = 0; } ;
STN1	: { $$ = $<stno>-1; } ;
STN2	: { $$ = $<stno>0; } ;
STN3	: { $$ = addstructtype($<lexstr>-1); } ;

WD	: { setstructwidth($<stno>-1); } ;

BASIC	: INT   { $$ = searchbasictype (INT); }
	| LNG   { $$ = searchbasictype (LNG); }
	| FLT   { $$ = searchbasictype (FLT); }
	| DBL   { $$ = searchbasictype (DBL); }
	;

LIST	: LIST ',' VT4 VAR
	| VT5 VAR
	;

VAR	: ID VT6 DIM   { STadd($1,$3->typeref,$3->stno); }
	;

DIM	: '[' NUM ']' VT7 DIM { $$ = genattr(addarraytype($2,$5->typeref),$5->stno); }
	| { $$ = $<attr>0; }
	;

VT1	: { $$ = genattr($<typeref>0, $<stno>-1); } ;
VT2	: { $$ = genattr(getstref($<stno>-3), $<stno>-7); } ;
VT3	: { $$ = genattr(searchstructtype($<lexstr>0), $<stno>-2); } ;
VT4	: { $$ = $<attr>-2; } ;
VT5	: { $$ = $<attr>0; } ;
VT6	: { $$ = $<attr>-1; } ;
VT7	: { $$ = $<attr>-3; } ;

STMTLIST	:  STMTLIST STMT  { }
		|  { }
		;

STMT	: ASGN  { }
	;

ASGN	: ITEM '=' EXPR ';'  { memstore($1,$3); }
	;

EXPR	: EXPR '+' TERM  { $$ = operation($1, '+', $3); }
	| EXPR '-' TERM  { $$ = operation($1, '-', $3); }
	| EXPR ICONST {
             if ($2 > 0) $$ = operation($1, '+', iconst2addr($2));
             else if ($2 < 0) $$ = operation($1, '-', iconst2addr(-$2));
             else $$ = $1;
          }
	| EXPR FCONST {
             if ($2 > 0) $$ = operation($1, '+', fconst2addr($2));
             else if ($2 < 0) $$ = operation($1, '-', fconst2addr(-$2));
             else $$ = $1;
          }
	| TERM  { $$ = $1; }
	;

TERM	: TERM '*' FACTOR { $$ = operation($1, '*', $3); }
	| TERM '/' FACTOR { $$ = operation($1, '/', $3); }
	| TERM '%' FACTOR { $$ = operation($1, '%', $3); }
	| FACTOR { $$ = $1; }
	;

FACTOR	: ICONST  { $$ = iconst2addr($1); }
	| NUM  { $$ = iconst2addr($1); }
	| FCONST  { $$ = fconst2addr($1); }
	| UFLT  { $$ = fconst2addr($1); }
	| ITEM  { $$ = item2addr($1); }
	| '(' EXPR ')' { $$ = $2; }
	;

ITEM	: STN0 SMPLITEM { $$ = $2; }
	| ITEM '.' STN4 SMPLITEM { $$ = struct2addr($1,$4); }
	;

STN4	: { $$ = getstructref($<addr>-1 -> type); }

SMPLITEM  : ID { $$ = id2addr($1, $<stno>0); }
	  | AREF { $$ = $1; }
	  ;

AREF	: AREF '[' EXPR ']'  { $$ = arr2addr($1, $3); }
	| ID '[' EXPR ']' { $$ = arrid2addr($1, $3, $<stno>0); }
	;

%%

