#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>

int xpid, opid;

void printboard ( char B[][3] )
{
   printf(" %c | %c | %c \n", B[0][0], B[0][1], B[0][2]);
   printf("---+---+---\n");
   printf(" %c | %c | %c \n", B[1][0], B[1][1], B[1][2]);
   printf("---+---+---\n");
   printf(" %c | %c | %c \n\n", B[2][0], B[2][1], B[2][2]);
}

char checkboard ( char B[][3] )
{
   int i;

   for (i=0; i<3; ++i) {
      if ( (B[i][0] != ' ') && (B[i][1] == B[i][0]) && (B[i][2] == B[i][0]) ) return B[i][0];
      if ( (B[0][i] != ' ') && (B[1][i] == B[0][i]) && (B[2][i] == B[0][i]) ) return B[0][i];
   }
   if ( (B[0][0] != ' ') && (B[1][1] == B[0][0]) && (B[2][2] == B[0][0]) ) return B[0][0];
   if ( (B[0][2] != ' ') && (B[1][1] == B[0][2]) && (B[2][0] == B[0][2]) ) return B[0][2];
   return ' ';
}

void endgame ( int sig )
{
   kill(xpid, SIGINT); waitpid(xpid, NULL, 0);
   kill(opid, SIGINT); waitpid(opid, NULL, 0);
   printf("Players exited\nBye...\n");
   exit(0);
}

void rungame ( char B[][3] , int xpid, int opid )
{
   int row, col, nmove = 0;
   char player, winner;
   int plrpid;

   printboard(B);
   while (1) {
      player = (nmove % 2 == 0) ? 'X' : 'O';
      plrpid = (nmove % 2 == 0) ? xpid : opid;
      printf("[%c] ", player); fflush(stdout);
      kill(plrpid, SIGUSR1);
      scanf("%d%d", &row, &col);
      if ((row < 0) || (row > 2) || (col < 0) || (col > 2) || (B[row][col] != ' ')) {
         printf("Invalid move...\n");
         continue;
      }
      ++nmove;
      B[row][col] = player;
      printboard(B);
      winner = checkboard(B);
      if (winner == player) { printf("Player %c wins\n", player); break; }
      if (nmove == 9) { printf("Game ends in a draw\n"); break; }
   }
   endgame(SIGINT);
}

int main ( )
{
   int pfd[2];
   char pipefd[16];
   char B[3][3] = { { ' ', ' ', ' ' }, { ' ', ' ', ' ' }, { ' ', ' ', ' '} };

   pipe(pfd);
   sprintf(pipefd, "%d", pfd[1]);

   xpid = fork();
   if (!xpid) execlp("player", "./player", "X", pipefd, NULL);

   opid = fork();
   if (!opid) execlp("player", "./player", "O", pipefd, NULL);

   signal(SIGINT, endgame);

   close(0); dup(pfd[0]);

   usleep(100000);
   rungame(B, xpid, opid);

   exit(0);
}
