#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ipc.h>
#include <sys/shm.h>

int n;
int nextplr = 0;
int plrshm, brdshm;
pid_t *plrpid, brdpid;
int self;

void nextmove ( int sig )
{
   int *P, *B, prevpos, nextpos, move, toss, i;


   printf("****************************************\n");
   printf("Player %c: ", 'A' + self); fflush(stdout);

   move = 0;
   while (move % 6 == 0) {
      toss = 1 + rand() % 6;
      move += toss;
      if (move <= 6) printf("%d", toss); else printf(" + %d", toss);
      fflush(stdout);
      if (move == 18) { printf(" X "); move = 0; fflush(stdout); }
   }

   printf("\n"); fflush(stdout);

   P = (int *)shmat(plrshm, NULL, 0);
   prevpos = P[self];
   if (prevpos + move > 100) {
      printf("Move not permitted (cannot go beyond 100)\n");
   } else {
      B = (int *)shmat(brdshm, NULL, 0);
      nextpos = prevpos + move;
      while (B[nextpos] != 0) {
         if (B[nextpos] > 0) printf("Ladder at cell %d. Jump to ", nextpos);
         else if (B[nextpos] < 0) printf("Snake at cell %d. Jump to ", nextpos);
         nextpos += B[nextpos];
         printf("%d\n", nextpos); fflush(stdout);
      }
      shmdt(B);
      for (i=0; i<n; ++i) {
         if ((i != self) && (nextpos != 100) && (P[i] == nextpos)) {
            printf("Move not permitted (cell already occupied by %c)\n", 'A' + i);
            break;
         }
      }
      if (i == n) {
         P[self] = nextpos;
         if (nextpos == 100) {
            --P[n];
            printf("Player %c exits with rank = %d\n", 'A' + self, n - P[n]);
            shmdt(P);
            kill(brdpid, SIGUSR1);
            fflush(stdout);
            sleep(1);
            exit(0);
         }
         printf("Player %c moves to cell %d\n", 'A' + self, nextpos);
      }
   }
   fflush(stdout);
   shmdt(P);
   kill(brdpid, SIGUSR1);
}

void pmain ( int i )
{
   self = i;
   srand((unsigned int)getpid());
   brdshm = shmget(ftok("/home", 'b'), 101 * sizeof(int), 0777);
   plrshm = shmget(ftok("/home", 'p'), (n + 1) * sizeof(int), 0777);
   signal(SIGUSR1, nextmove);

   while (1) pause();
}

void wakeup ( int sig )
{
   int *P, plrtomove;

   P = shmat(plrshm, NULL, 0);
   if (P[n] > 0) {
      while (P[nextplr] == 100) { ++nextplr; if (nextplr == n) nextplr = 0; }
      plrtomove = nextplr;
      ++nextplr; if (nextplr == n) nextplr = 0;
      shmdt(P);
      kill(plrpid[plrtomove],SIGUSR1);
   }
}

void endgame ( int sig )
{
   int i, *P;

   P = shmat(plrshm, NULL, 0);
   for (i=0; i<n; ++i) {
      if (P[i] != 100) kill(plrpid[i], SIGINT);
      waitpid(plrpid[i], NULL, 0);
      printf("PLayer %c exited\n", 'A' + i);
      fflush(stdout);
      sleep(1);
   }
   shmdt(P);
   exit(0);
}

int main ( int argc, char *argv[] )
{
   int i;
   int pfd, dupout;

   n = atoi(argv[1]);
   pfd = atoi(argv[2]);
   brdpid = atoi(argv[3]);

   dupout = dup(1);
   close(1);
   dup(pfd);
   printf("%d\n",getpid());
   fflush(stdout);
   close(1);
   dup(dupout);

   plrshm = shmget(ftok("/home", 'p'), (n + 1) * sizeof(int), 0777);
   plrpid = (pid_t *)malloc(n * sizeof(pid_t));

   for (i=0; i<n; ++i) {
      plrpid[i] = fork();
      if (!plrpid[i]) pmain(i);
   }

   signal(SIGUSR1, wakeup);
   signal(SIGUSR2, endgame);

   while (1) pause();

   exit(0);
}
