#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>

#define TRANSITION 1
#define QUIT 2
#define ENDOFINPUT -1

int s, n;
int *cpid;
int cfd[2], (*sfd)[2];
int dupin, dupout;

int **readfile ( char * ) ;
void runstate ( int ) ;
void createpipes ( ) ;
void createstates ( int ** ) ;
void userloop ( ) ;
void stateloop ( int, int, int, int * ) ;
void enduserloop ( int ) ;

int **readfile ( char *fname )
{
   int **delta, i, j, q;
   FILE *fp;
   char isfinal[64];

   fp = (FILE *)fopen(fname,"r");
   fscanf(fp, "%d%d", &s, &n);
   delta = (int **)malloc(n * sizeof(int *));
   for (i=0; i<n; ++i) delta[i] = (int *)malloc((s + 1) * sizeof(int));
   for (i=0; i<n; ++i) {
      fscanf(fp, "%d%s", &q, isfinal);
      delta[q][s] = ( (isfinal[0] == 'F') || (isfinal[0] == 'f') );
      for (j=0; j<s; ++j) fscanf(fp, "%d", delta[q]+j);
   }
   fclose(fp);
   return delta;
}

void createpipes ( )
{
   int q;

   pipe(cfd);
   sfd = (int(*)[2])malloc(n * 2 * sizeof(int));
   for (q=0; q<n; ++q) pipe(sfd[q]);
   dupin = dup(0); dupout = dup(1);
}

void createstates ( int **delta )
{
   int q, j;
   char msg[128];

   cpid = (int *)malloc(n * sizeof(int));
   for (q=0; q<n; ++q) {
      cpid[q] = fork();
      if (cpid[q] == 0) runstate(q);
      close(1); dup(sfd[q][1]);
      printf("%d", s);
      for (j=0; j<=s; ++j) printf(" %d", delta[q][j]);
      printf("\n");
      fflush(stdout);
      close(1); dup(dupout);
   }
   usleep(500000); /* Wait until the child processes are active to run */
   sprintf(msg, "+++ Coordinator: %d state processes are created", n);
   printf("%80s\n", msg);
   fflush(stdout);
}

void runstate ( int q )
{
   int *mydelta, s, isfinal, i;
   char msg[128];

   close(0); dup(sfd[q][0]);
   scanf("%d", &s);
   mydelta = (int *)malloc(s * sizeof(int));
   for (i=0; i<s; ++i) scanf("%d", mydelta + i);
   scanf("%d", &isfinal);
   sprintf(msg, "+++ %s state %d created", (isfinal) ? "Final" : "Non-final", q);
   #ifdef _VERBOSE
   printf("%80s\n", msg);
   fflush(stdout);
   #endif
   stateloop(s,q,isfinal,mydelta);
   exit(0);
}

void enduserloop ( int sig )
{
   int q;

   #ifdef _VERBOSE
   printf("\n\n");
   printf("%80s\n", "+++ Coordinator going to terminate all state processes");
   fflush(stdout);
   #endif
   for (q=0; q<n; ++q) {
      fflush(stdout);
      close(1); dup(sfd[q][1]);
      printf("%d\n", QUIT);
      fflush(stdout);
      close(1); dup(dupout);
      waitpid(cpid[q], NULL, 0);
   }
   #ifdef _VERBOSE
   printf("%80s\n", "+++ Coordinator: Bye");
   #else
   printf("\n");
   printf("%80s\n", "+++ Coordinator: All state processes terminated. Bye.");
   #endif
   fflush(stdout);

   exit(0);
}

void userloop ( )
{
   char input[1024];
   int i, l, q;

   signal(SIGINT, enduserloop);
   #ifdef _VERBOSE
   printf("%80s\n\n", "+++ Coordinator: Going to user loop"); fflush(stdout);
   #endif
   while (1) {
      printf("Enter next string: "); fflush(stdout);
      fgets(input,1024,stdin);
      l = strlen(input) - 1; input[l] = '\0';
      printf("0"); fflush(stdout);
      close(1); dup(sfd[0][1]);
      printf("%d\n", TRANSITION); fflush(stdout);
      close(1); dup(dupout);
      for (i=0; i<=l; ++i) {
         close(0); dup(cfd[0]);
         scanf("%d", &q);
         while (getchar() != '\n');
         close(0); dup(dupin);
         close(1); dup(sfd[q][1]);
         if (input[i] == '\0') printf("%d\n", ENDOFINPUT);
         else printf("%d\n", input[i] - 'a');
         fflush(stdout);
         close(1); dup(dupout);
         if ( (input[i] < 'a') || (input[i] >= 'a' + s) ) break;
         else if ((input[i] != '\0') && (i % 6 == 5) ) { printf("\n "); fflush(stdout); }
      }
      usleep(10000);
   }
}

void stateloop ( int s, int q, int isfinal, int *mydelta )
{
   int command, nextsymb, qnext;
   char msg[128];

   signal(SIGINT, SIG_IGN);
   while (1) {
      close(0); dup(sfd[q][0]);
      scanf("%d", &command);
      close(0); dup(dupin);
      if (command == QUIT) {
         sprintf(msg, "+++ State %d going to quit", q);
         #ifdef _VERBOSE
         printf("%80s\n", msg);
         fflush(stdout);
         #endif
         exit(0);
      }
      if (command == TRANSITION) {
         close(1); dup(cfd[1]);
         printf("%d\n", q); fflush(stdout);
         close(1); dup(dupin);
         close(0); dup(sfd[q][0]);
         scanf("%d", &nextsymb);
         if ( (nextsymb < -1) || (nextsymb >= s) ) {
            printf(" INVALID INPUT SYMBOL: %c\n", 'a' + nextsymb);
            fflush(stdout);
         } else if (nextsymb == ENDOFINPUT) {
            if (isfinal) printf(" ACCEPT\n"); else printf(" REJECT\n");
            fflush(stdout);
         } else {
            qnext = mydelta[nextsymb];
            printf(" -- %c --> %d", 'a' + nextsymb, qnext); fflush(stdout);
            close(1); dup(sfd[qnext][1]);
            printf("%d\n", TRANSITION);
            fflush(stdout);
            close(1); dup(dupout);
         }
      }
   }
}

int main ( int argc, char *argv[] )
{
   char *fname;
   int **delta;

   fname = (argc == 1) ? strdup("dfa.txt") : argv[1];
   delta = readfile(fname);
   createpipes();
   createstates(delta);
   userloop();

   exit(0);
}
