#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>

int cno;
int bookinginprogress = 0, nbooking = 0;

void buyticket ( int s )
{
   FILE *fp;
   int r;

   if ((!bookinginprogress) && ((nbooking == 2) || ((nbooking == 1) && (rand() % 2)))) {
      printf("\t\t\t\t\tCustomer %3d leaves the booking system\n", cno);
      kill(getppid(), SIGUSR2);
      exit(0);
   }

   if (s == SIGUSR1) {
      if (bookinginprogress) {
         ++nbooking;
         printf("\t\t\t\t\tCustomer %3d: Booking %d successful\n", cno, nbooking);
         bookinginprogress = 0;
      } else {
         r = 1 + rand() % 4;
         fp = (FILE *)fopen("request.txt", "w");
         fprintf(fp, "%d %d\n", cno, r);
         fclose(fp);
         bookinginprogress = 1;
         printf("\t\t\t\t\tCustomer %3d: Request for %d tickets\n", cno, r);
         kill(getppid(), SIGUSR1);
      }
   } else if (s == SIGUSR2) {
      if (bookinginprogress) {
         printf("\t\t\t\t\tCustomer %3d: Booking %d failed\n", cno, nbooking + 1);
         bookinginprogress = 0;
      }
   }
}

int main ( int argc, char *argv[] )
{
   if (argc == 1) {
      fprintf(stderr, "*** Run with the customer number\n");
      exit(1);
   }
   cno = atoi(argv[1]);
   srand((unsigned int)getpid());
   printf("\t\t\t\t\tCustomer %3d joins the booking system\n", cno);

   signal(SIGUSR1, buyticket);
   signal(SIGUSR2, buyticket);

   while (1) pause();

   exit(0);
}
