#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>

typedef struct {
   int *A;
   int F, B;
} queue;

queue Q;
int t, n, *cpid, nextcust;
char cno[16];

int *createcustomers ( )
{
   int i, *cpid;

   if (n <= 0) {
      fprintf(stderr, "*** I need at least one customer\n");
      exit(1);
   }

   cpid = (int *)malloc((n + 1) * sizeof(int));
   for (i=1; i<=n; ++i) {
      cpid[i] = fork();
      if (cpid[i] == 0) {
         sprintf(cno,"%d",i);
         execlp("customer", "./customer", cno, NULL);
         fprintf(stderr, "*** Customer %d is unable to exec\n", i);
         exit(1);
      }
      /* Agent waits for the customer to enter the system */
      usleep(100000);
   }

   return cpid;
}

queue initQ ( )
{
   queue Q;
   int i, j, k;

   Q.A = (int *)malloc(10 * n * sizeof(int));
   for (i=0; i<n; ++i) Q.A[i] = i + 1;
   for (i=n-1; i>0; --i) {
      j = rand() % i;
      k = Q.A[i]; Q.A[i] = Q.A[j]; Q.A[j] = k;
   }
   Q.F = 0; Q.B = n-1;
   return Q;
}

void printstatus ( )
{
   int i;

   usleep(100000);  /* a small wait to avoid cluttered printing */
   printf("\nAgent: Queue = (");
   for (i=Q.F; i<=Q.B; ++i) printf(" %d", Q.A[i]);
   printf(" ) Available = %d\n", t);
}

void terminatequeue ( )
{
   int i;

   usleep(200000);
   printf("\nAgent terminates customers");
   for (i=Q.F; i<=Q.B; ++i) {
      printf(" %d", Q.A[i]);
      kill(cpid[Q.A[i]], SIGKILL);
      waitpid(cpid[Q.A[i]], NULL, 0);
   }
   printf("\n\nAgent: Booking session over (no more tickets available)\n");
   exit(0);
}

void bookcycle ( int s )
{
   FILE *fp;
   int c, r;

   if (s == SIGUSR2) {
      waitpid(cpid[nextcust], NULL, 0);
   } else {
      fp = (FILE *)fopen("request.txt", "r");
      fscanf(fp, "%d%d", &c, &r);
      fclose(fp);
      if (c != nextcust) {
         fprintf(stderr, "Agent: Expecting request from %d instead of %d\n", nextcust, c);
         kill(cpid[c], SIGUSR2);
      } else if (r <= t) {
         t -= r;
         ++Q.B; Q.A[Q.B] = c;
         kill(cpid[c], SIGUSR1);
      } else {
         ++Q.B; Q.A[Q.B] = c;
         kill(cpid[c], SIGUSR2);
      }
   }

   if (t == 0) terminatequeue();
   if (Q.F > Q.B) {
      printf("\nAgent: Booking session over (no more customers available)\n");
      exit(0);
   }

   printstatus();
   nextcust = Q.A[Q.F]; 
   ++Q.F;
   kill(cpid[nextcust], SIGUSR1);
}

void startbooking ( )
{
   printstatus();
   nextcust = Q.A[Q.F];
   ++Q.F;
   kill(cpid[nextcust], SIGUSR1);

   while (1) pause();
}

int main ( int argc, char *argv[] )
{
   if (argc == 1) { t = 64; n = 16; }
   else if (argc == 2) { t = atoi(argv[1]); n = 10; }
   else { t = atoi(argv[1]); n = atoi(argv[2]); }

   srand((unsigned int)getpid());
   signal(SIGUSR1, bookcycle);
   signal(SIGUSR2, bookcycle);

   cpid = createcustomers();
   Q = initQ();
   startbooking();

   exit(0);
}
