%{
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "y.tab.h"
%}

ws	[ \t\n]+
id	[a-zA-Z_][a-zA-Z0-9_]*
num	[0-9]+

%%

{ws}				{ }
void				{ return VOID; }
unsigned{ws}char		{ return UCHR; }
char				{ return CHR; }
unsigned{ws}short{ws}int	{ return USRT; }
unsigned{ws}short		{ return USRT; }
short{ws}int			{ return SRT; }
short				{ return SRT; }
unsigned{ws}long{ws}int		{ return ULNG; }
unsigned{ws}long		{ return ULNG; }
long{ws}int			{ return LNG; }
long				{ return LNG; }
unsigned{ws}int			{ return UINT; }
unsigned			{ return UINT; }
int				{ return INT; }
float				{ return FLT; }
double				{ return DBL; }
{id}				{ yylval.lexstr = strdup(yytext); return ID; }
{num}				{ yylval.lexval = atoi(yytext); return NUM; }
\*				{ return yytext[0]; }
\[				{ return yytext[0]; }
\]				{ return yytext[0]; }
,				{ return yytext[0]; }
;				{ return yytext[0]; }
.				{ fprintf(stderr, "*** Lex error: Unrecognized char '%s'\n", yytext); }

%%

int yywrap ( ) { return 1; }
